package gov.va.vinci.dart.db.mock;

import gov.va.vinci.dart.common.exception.ObjectNotFoundException;
import gov.va.vinci.dart.biz.DataSourceDisplayHeader;
import gov.va.vinci.dart.db.DataSourceDisplayHeaderDAO;
import gov.va.vinci.dart.db.util.HibernateDAO;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class DataSourceDisplayHeaderDAOMock  extends HibernateDAO implements DataSourceDisplayHeaderDAO {
	private static final HashMap<Integer,DataSourceDisplayHeader> IDHash = new HashMap<Integer,DataSourceDisplayHeader>();
	
	private static boolean initialized = false;

	
	@Override
	public DataSourceDisplayHeader findById(int displayHeaderId) throws ObjectNotFoundException {
		initializeDataSourceDisplayHeaderHash();

		DataSourceDisplayHeader result = IDHash.get(displayHeaderId);

		if (result == null) {
			throw new ObjectNotFoundException();
		}

		return result;
	}


	@Override
	public List<DataSourceDisplayHeader> listAll() {
		List<DataSourceDisplayHeader> result = new ArrayList<DataSourceDisplayHeader>();
		
		initializeDataSourceDisplayHeaderHash();
		
		for (Integer id: IDHash.keySet()) {
			result.add(IDHash.get(id));
		}

		return result;	
	}

	
	@Override
	public List<DataSourceDisplayHeader> listAllByRequestType(final int requestTypeId) {
		List<DataSourceDisplayHeader> result = new ArrayList<DataSourceDisplayHeader>();
		
		initializeDataSourceDisplayHeaderHash();
		
		for (Integer id: IDHash.keySet()) {

			DataSourceDisplayHeader dsHeader = IDHash.get(id);

			if( dsHeader != null && dsHeader.getRequestTypeId() == requestTypeId ) {
				result.add( dsHeader );	//keep this header
			}
		}

		return result;	
	}	
	
	
	private void initializeDataSourceDisplayHeaderHash() {
		if (initialized == true) {
			return;
		}
		
		try {
			initializeDataSourceDisplayHeaderHash0();
			initialized = true;
		} catch (ObjectNotFoundException e) {
			e.printStackTrace();
		}
	}
	
	private void initializeDataSourceDisplayHeaderHash0() throws ObjectNotFoundException {
		
		DataSourceDisplayHeader h = new DataSourceDisplayHeader();
		h.setId(1);
		h.setName("Corporate Data Warehouse (CDW)");
		h.setDescription("Corporate Data Warehouse (CDW)");
		h.setHeadId(0);
		h.setSortOrder(1);
		h.setRequestTypeId(2);
		IDHash.put(h.getId(), h);
		
		h.setId(2);
		h.setName("SQL Format");
		h.setDescription("SQL Format");
		h.setHeadId(1);
		h.setSortOrder(1);
		h.setRequestTypeId(2);
		IDHash.put(h.getId(), h);

		h.setId(3);
		h.setName("SAS Format");
		h.setDescription("SAS Format");
		h.setHeadId(1);
		h.setSortOrder(2);
		h.setRequestTypeId(2);
		IDHash.put(h.getId(), h);

		h.setId(4);
		h.setName("Mainframe - Access");
		h.setDescription("Mainframe - Access");
		h.setHeadId(0);
		h.setSortOrder(2);
		h.setRequestTypeId(2);
		IDHash.put(h.getId(), h);

		h.setId(5);
		h.setName("Other Data");
		h.setDescription("Other Data");
		h.setHeadId(0);
		h.setSortOrder(3);
		h.setRequestTypeId(2);
		IDHash.put(h.getId(), h);

		h.setId(6);
		h.setName("Data Access Systems");
		h.setDescription("Data Access Systems");
		h.setHeadId(0);
		h.setSortOrder(4);
		h.setRequestTypeId(2);
		IDHash.put(h.getId(), h);
	}
	
}